---------------------------
-- Initialization phase

if not dLocus then
   dLocus= Vec2(0,-180) ;
end

if not gActive then
   gActive = 9999 --3
end 

-- Allocate a velocity particle property as a Vec2
pVelocity = Allocate(2) ;
pAge = Allocate(1) ; -- Allocate a TReal age member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member
pLivingTime = Allocate(1); -- living time


-- Initialize values
pPosition:Init( fRange( Vec2(-300,-100), Vec2(400,500) ) + dLocus );
pVelocity:Init( fRange( Vec2(-80,120), Vec2(-80,80) ) );
pColor:Init( Color(1,1,1,1) );
pScale:Init( fRange( 0.4, 0.85 ) );
pAge:Init(0);
pSpin:Init( fRange( 0, 2*3.1415927 ) );
pSpinSpeed:Init( fRange( -2, 2 ) );
pLivingTime:Init( fRange(2000,5000) );

-- Set the particle texture
SetTexture("snowflake");

-- Set the blend mode
SetBlendMode(kBlendNormal);


-- Initialize the raw particles--do this last in the Initialization Phase
SetNumParticles(200);

---------------------------
-- Action phase

-- Animate the velocity, position and scale
--pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,800)) );
pPosition:Anim( pPosition + fTimeScale(pVelocity) );
pScale:Anim( pScale - fTimeScale(0.07) );

pAge:Anim( pAge+fAge() );
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );
pUp:Anim( f2dRotation( pSpin ) );
Anim( fExpire( fGreater(pAge,pLivingTime+1000) ) );
pColor:Anim( fFade( pAge, Color(1,1,1,0),500, Color(1,1,1,1),pLivingTime,Color(1,1,1,1), 500, Color(1,1,1,0) ) );

-- Create an initial particle
CreateParticles( 1 );


-- A global variable that we can set from outside
--gActive = 1

-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
   if gActive>0 then
      CreateParticles( seconds * 35 );
      gActive = gActive - seconds
   end
end

